/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.items;

import com.dhanantry.scapeandrunparasites.block.BlockGore;
import com.dhanantry.scapeandrunparasites.entity.EntityRemain;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import energon.srpextra.config.SRPEConfigItems;
import energon.srpextra.entity.tile.EntityRemainAqua;
import energon.srpextra.items.SRPEItemBase;
import energon.srpextra.items.SRPEItemCheck;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SRPEItemRemainsCanister
extends SRPEItemBase {
    public SRPEItemRemainsCanister(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("container"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack itemStack, @Nullable World world, @Nullable EntityLivingBase entityLivingBase) {
                if (itemStack.func_77942_o()) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        BlockPos blockPos;
        RayTraceResult rayTraceResult;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77942_o() && (rayTraceResult = this.func_77621_a(world, player, true)) != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(blockPos = rayTraceResult.func_178782_a()).func_185904_a().func_76224_d() && stack.func_77978_p().func_74764_b("ParasiteElement")) {
            if (!world.field_72995_K && this.summonAqua(blockPos, world, stack, player) && SRPEConfigItems.debugCanister) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.failed")));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        Entity hitEntity = SRPEItemCheck.rayTraceEntity(world, player, 4.0);
        if (hitEntity instanceof EntityRemainAqua) {
            if (!world.field_72995_K) {
                EntityRemainAqua remainAqua = (EntityRemainAqua)hitEntity;
                SRPEItemRemainsCanister.addParasiteToCanister(stack, remainAqua.parasite, remainAqua.skin, SRPEItemRemainsCanister.getTypeByRemainType(remainAqua.getStateType()));
                remainAqua.func_70106_y();
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("ParasiteElement")) {
            if (!world.field_72995_K && this.summon(pos.func_177972_a(facing), world, stack, player) && SRPEConfigItems.debugCanister) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.failed")));
            }
            return EnumActionResult.SUCCESS;
        }
        String name = null;
        List entities = world.func_72872_a(EntityRemain.class, new AxisAlignedBB(pos));
        for (Entity entity : entities) {
            if (!(entity instanceof EntityRemain)) continue;
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            name = SRPEItemRemainsCanister.addParasiteToCanister(stack, (String)SRPEItemCheck.getFieldValue(entity, "parasite"), (Byte)SRPEItemCheck.getFieldValue(entity, "skin"), SRPEItemRemainsCanister.getTypeByBlock(world, pos));
            world.func_175698_g(pos);
            entity.func_70106_y();
            break;
        }
        if (name != null) {
            if (SRPEConfigItems.debugCanister) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.saved") + " " + name.split(";")[0]));
            }
            return EnumActionResult.SUCCESS;
        }
        if (SRPEConfigItems.debugCanister) {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.failed")));
        }
        return EnumActionResult.FAIL;
    }

    public static String getTypeByRemainType(byte type) {
        switch (type) {
            case 1: {
                return ";pri;";
            }
            case 2: {
                return ";ada;";
            }
            case 3: {
                return ";pure;";
            }
        }
        return ";sim;";
    }

    public static String getTypeByBlock(World world, BlockPos pos) {
        switch ((BlockGore.EnumType)world.func_180495_p(pos).func_177229_b((IProperty)BlockGore.VARIANT)) {
            case PRI_BIG: {
                return ";pri;";
            }
            case ADA_BIG: {
                return ";ada;";
            }
            case PURE_BIG: {
                return ";pure;";
            }
        }
        return ";sim;";
    }

    public static byte getTypeByString(String part) {
        switch (part) {
            case "pri": {
                return 1;
            }
            case "ada": {
                return 2;
            }
            case "pure": {
                return 3;
            }
        }
        return 0;
    }

    public static float getHealthMultiByType(byte type) {
        switch (type) {
            case 1: {
                return 1.3f;
            }
            case 2: {
                return 1.5f;
            }
            case 3: {
                return 2.0f;
            }
        }
        return 1.0f;
    }

    public static int getTimeReByType(byte type) {
        switch (type) {
            case 1: {
                return 20 * SRPConfig.primitiveRemainValue;
            }
            case 2: {
                return 20 * SRPConfig.adaptedRemainValue;
            }
            case 3: {
                return 20 * SRPConfig.pureRemainValue;
            }
        }
        return 20 * SRPConfig.infectedRemainValue;
    }

    public static String addParasiteToCanister(ItemStack stack, String name, byte skin, String type) {
        if (name == null) {
            return null;
        }
        name = name + type;
        name = name + Byte.toString(skin);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("ParasiteElement", name);
        return name;
    }

    private boolean summon(BlockPos pos, World world, ItemStack itemStack, EntityPlayer player) {
        String[] element = itemStack.func_77978_p().func_74779_i("ParasiteElement").split(";");
        if (element.length == 3) {
            byte type = 0;
            switch (element[1]) {
                case "sim": {
                    world.func_175656_a(pos, SRPBlocks.Gore.func_176223_P().func_177226_a((IProperty)BlockGore.VARIANT, (Comparable)BlockGore.EnumType.SIM_BIG));
                    break;
                }
                case "pri": {
                    type = 1;
                    world.func_175656_a(pos, SRPBlocks.Gore.func_176223_P().func_177226_a((IProperty)BlockGore.VARIANT, (Comparable)BlockGore.EnumType.PRI_BIG));
                    break;
                }
                case "ada": {
                    type = 2;
                    world.func_175656_a(pos, SRPBlocks.Gore.func_176223_P().func_177226_a((IProperty)BlockGore.VARIANT, (Comparable)BlockGore.EnumType.ADA_BIG));
                    break;
                }
                case "pure": {
                    type = 3;
                    world.func_175656_a(pos, SRPBlocks.Gore.func_176223_P().func_177226_a((IProperty)BlockGore.VARIANT, (Comparable)BlockGore.EnumType.PURE_BIG));
                }
            }
            EntityRemain remain = new EntityRemain(world);
            remain.setSkin(Byte.parseByte(element[2]));
            remain.setGoal(SRPEItemRemainsCanister.getTimeReByType(type));
            remain.setParasite(element[0]);
            remain.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            world.func_72838_d((Entity)remain);
            if (SRPEConfigItems.debugCanister) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.placed")));
            }
            if (!player.func_184812_l_()) {
                itemStack.func_77982_d(null);
            }
            return false;
        }
        return true;
    }

    private boolean summonAqua(BlockPos pos, World world, ItemStack itemStack, EntityPlayer player) {
        String[] element = itemStack.func_77978_p().func_74779_i("ParasiteElement").split(";");
        if (element.length == 3) {
            EntityRemainAqua remainAqua = new EntityRemainAqua(world);
            byte type = SRPEItemRemainsCanister.getTypeByString(element[1]);
            remainAqua.setStateType(type);
            remainAqua.setSkin(Byte.parseByte(element[2]));
            remainAqua.setGoal(SRPEItemRemainsCanister.getTimeReByType(type));
            remainAqua.setParasite(element[0]);
            remainAqua.entityHealth *= SRPEItemRemainsCanister.getHealthMultiByType(type);
            remainAqua.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            world.func_72838_d((Entity)remainAqua);
            if (SRPEConfigItems.debugCanister) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.placed")));
            }
            if (!player.func_184812_l_()) {
                itemStack.func_77982_d(null);
            }
            return false;
        }
        return true;
    }

    public void func_77624_a(ItemStack itemStack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("ParasiteElement")) {
            String[] element = itemStack.func_77978_p().func_74779_i("ParasiteElement").split(";");
            if (element.length == 3) {
                tooltip.add(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.saved") + " " + element[0]);
            }
        } else {
            tooltip.add(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.empty"));
        }
    }
}

